
/*******************************************************************/
/*                                                                 */
/*                      ADOBE CONFIDENTIAL                         */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
/*                                                                 */
/* Copyright 1994 - 1999 Adobe Systems Incorporated                */
/* All Rights Reserved.                                            */
/*                                                                 */
/* NOTICE:  All information contained herein is, and remains the   */
/* property of Adobe Systems Incorporated and its suppliers, if    */
/* any.  The intellectual and technical concepts contained         */
/* herein are proprietary to Adobe Systems Incorporated and its    */
/* suppliers and may be covered by U.S. and Foreign Patents,       */
/* patents in process, and are protected by trade secret or        */
/* copyright law.  Dissemination of this information or            */
/* reproduction of this material is strictly forbidden unless      */
/* prior written permission is obtained from Adobe Systems         */
/* Incorporated.                                                   */
/*                                                                 */
/*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		CryTIFPlugin.h
//
//	Description:
//		This file contains the header prototypes and macros for the
//		File Format module CryTIFPlugin, 
//		which writes a flat file with merged document pixels.
//
//	Use:
//		Format modules are called from the Save, Save as,
//		and Save a copy dialogs.
//
//	Version history:
//		Version 1.0.0	1/1/1994	Created for Photoshop 3.0.
//			Written by Mark Hamburg
//
//		Version 2.0.0	5/27/1996	Updated for Photoshop 4.0.
//			Scripting added.
//
//		Version 2.1.0	6/28/1997	Updated for Photoshop 4.0.1.
//			Updated for new version of Photoshop and projects
//			moved to CodeWarrior Pro.
//
//-------------------------------------------------------------------------------

#ifndef __CryTIFPlugin_H__
#define __CryTIFPlugin_H__

#include "PIFormat.h"													// Format Photoshop header file.
#include "PIUtilities.h"											// SDK Utility library.
#include "FileUtilities.h"										// File Utility library.
#include "CryTIFPluginTerminology.h"					// Terminology for plug-in.


typedef	struct tiff TIFF;

//-------------------------------------------------------------------------------
//	Structure -- FileHeader
//-------------------------------------------------------------------------------
/*
typedef struct FileHeader
{
	
	char identifier [8];
	
	int16 mode;
	int16 depth;
	int16 rows;
	int16 cols;
	int16 planes;
	
	int32 resourceLength;
	
} FileHeader;
*/

//-------------------------------------------------------------------------------
//	Globals -- structures
//-------------------------------------------------------------------------------

// Windows handle for our plug-in (seen as a dynamically linked library):
extern HANDLE hDllInstance;

typedef struct Globals
{ // This is our structure that we use to pass globals between routines:

	short *					result;							// Must always be first in Globals.
	FormatRecord *	formatParamBlock;		// Must always be second in Globals.

	Boolean					queryForParameters;

	BufferID				pixelBuffer;
	Ptr							pixelData;
	
	int32						rowBytes;
	
	Boolean					fooValueForRead;
	Boolean					barValueForWrite;
	
	Str255					history;

	TIFF *					m_pTiffFile;				// pointer ot the TIFF image, otherwise 0, AllocateGlobals() inits this with 0

} Globals, *GPtr, **GHdl;				// *GPtr = global pointer; **GHdl = global handle
	

// The routines that are dispatched to from the jump list should all be
// defined as
//		void RoutineName (GPtr globals);
// And this typedef will be used as the type to create a jump list:
typedef void (* FProc)(GPtr globals);

//-------------------------------------------------------------------------------
//	Globals -- definitions and macros
//-------------------------------------------------------------------------------

#define gResult				(*(globals->result))
#define gStuff				(globals->formatParamBlock)

#define gQueryForParameters	(globals->queryForParameters)

#define gPixelBuffer		(globals->pixelBuffer)
#define gPixelData			(globals->pixelData)
#define gRowBytes			(globals->rowBytes)

#define gFooRead			(globals->fooValueForRead)
#define gBarWrite			(globals->barValueForWrite)

#define gHistory			(globals->history)

//-------------------------------------------------------------------------------
//	Prototypes
//-------------------------------------------------------------------------------

// Everything comes in and out of PluginMain. It must be first routine in source:
DLLExport MACPASCAL void PluginMain (const short selector,
					  	             FormatRecord *formatParamBlock,
						             long *data,
						             short *result);

void InitGlobals (Ptr globalPtr);		  		// Initialize globals.
void DoAbout (AboutRecordPtr about); 	   		// Pop about box.

void ValidateParameters (GPtr globals);			// Validates (inits) parameters.
Boolean DoUI (GPtr globals);					// Show the UI.

// During read phase:
Boolean ReadScriptParamsOnRead (GPtr globals);	// Read any scripting params.
OSErr WriteScriptParamsOnRead (GPtr globals);	// Write any scripting params.

// During write phase:
Boolean ReadScriptParamsOnWrite (GPtr globals);	// Read any scripting params.
OSErr WriteScriptParamsOnWrite (GPtr globals);	// Write any scripting params.

//-------------------------------------------------------------------------------

#endif
